﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Reports
{
    public partial class NotPurchasedReport : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductsNeverPurchased(DateTime.MinValue, DateTime.MinValue);
            }
        }

        private void BindProductsNeverPurchased(DateTime fromDate, DateTime toDate)
        {
            DataTable bestSeller = ReportsBL.GetProductsNeverPurchased(fromDate, toDate);
            grdBestSellers.DataSource = bestSeller;
            grdBestSellers.DataBind();

            if (bestSeller.Rows.Count == 0)
                WebUtilities.ShowMessage(this, "No Products found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductsNeverPurchased(DateTime.MinValue, DateTime.MinValue);
            Master.ExportToExcel<Entities.Products>(grdBestSellers, "SlowMovingProductsReport");
        }

        protected void grdBestSellers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdBestSellers.PageIndex = e.NewPageIndex;
            BindProductsNeverPurchased((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindProductsNeverPurchased((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductsNeverPurchased(DateTime.Now, DateTime.Now);
        }
    }
}